using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.PlayerLoop;

namespace Lightsaber
{
    class Mod
    {
        public static void Main()
        {
            AddLightsaber("anakin", AudioPreset.Jedi, Color.cyan);
            AddLightsaber("anakin ep2", AudioPreset.Jedi, Color.cyan);
            AddLightsaber("obi-wan", AudioPreset.Jedi, Color.cyan);
            AddLightsaber("ezra", AudioPreset.Ezra, Color.cyan);
            AddLightsaber("kanan", AudioPreset.Jedi, Color.cyan);
            AddLightsaber("Jedi Knight", AudioPreset.Jedi, Color.cyan);
            AddLightsaber("fart master", AudioPreset.Fart, Color.green);
            AddLightsaber("Jedi Padawan", AudioPreset.Jedi, Color.green);
            AddLightsaber("Jedi Master", AudioPreset.Luke, Color.green);
            AddLightsaber("luke", AudioPreset.Luke, Color.green);
            AddLightsaber("qui-gon", AudioPreset.Jedi, Color.green);
            AddLightsaber("ahsoka", AudioPreset.Jedi, Color.green);
            AddLightsaber("ezra season 3", AudioPreset.Jedi, Color.green);
            AddLightsaber("yoda", AudioPreset.Jedi, Color.green, 1.3f, 0.02f);
            AddLightsaber("Jedi Master Tal'on", AudioPreset.Jedi2, new Color(0.2f, 1f, 0.2f, 1f));
            AddLightsaber("mace", AudioPreset.Jedi, Color.magenta);
            AddLightsaber("second revan", AudioPreset.Sith, Color.magenta);
            AddLightsaber("kylo", AudioPreset.Crossguard, Color.red, 1.5f, 0.2f, false, true);
            AddLightsaber("vader", AudioPreset.Sith, Color.red);
            AddLightsaber("revan", AudioPreset.Sith2, Color.red);
            AddLightsaber("sheev", AudioPreset.Sith, Color.red);
            AddLightsaber("dooku", AudioPreset.Luke, Color.red);
            AddLightsaber("maul single", AudioPreset.Sith2, Color.red);
            AddLightsaber("maul", AudioPreset.Sith2, Color.red, 1.5f, 0.4f, true);
            AddLightsaber("Sith Apprentice", AudioPreset.Sith, Color.red);
            AddLightsaber("Sith Master", AudioPreset.Sith2, Color.red);
            AddLightsaber("temple guard", AudioPreset.Guard, Color.yellow, 1.4f, 0.02f, true);
            AddLightsaber("ahsoka short", AudioPreset.Jedi, Color.yellow, 1.3f, 0.02f);
            AddLightsaber("asajj dark disciple", AudioPreset.Sith2, Color.yellow);
            AddLightsaber("ahsoka rebels", AudioPreset.Ahsoka, Color.white);
            AddLightsaber("ahsoka rebels shoto", AudioPreset.Ahsoka, Color.white, 1.3f, 0.02f);
        }

        private static void AddLightsaber(string name, AudioPreset audiopreset, Color color, float maxSaberLength = 1.5f, float minSaberLength = 0.2f, bool doubleBladed = false, bool crossguarded = false) // swap out this line
        {
            var lightsaber = new Modification()
            {
                OriginalItem = ModAPI.FindSpawnable("Rod"),
                NameOverride = name + "'s lightsaber -EL",
                DescriptionOverride = "an elegant weapon for a more civilised age",
                CategoryOverride = ModAPI.FindCategory("Melee"),
                NameToOrderByOverride = "lightsaber",
                ThumbnailOverride = ModAPI.LoadSprite(name + "_view.png"),
                AfterSpawn = (Instance) =>
                {
                    Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite(name + ".png");
                    Instance.GetComponent<PhysicalBehaviour>().Properties = ModAPI.FindPhysicalProperties("Weapon");
                    Instance.FixColliders();

                    LightsaberBehaviour lightsaberBehaviour = Instance.GetOrAddComponent<LightsaberBehaviour>();
                    lightsaberBehaviour.AudioPreset = audiopreset;
                    lightsaberBehaviour.MaxSaberLength = maxSaberLength;
                    lightsaberBehaviour.MinSaberLength = minSaberLength;
                    lightsaberBehaviour.DoubleBladed = doubleBladed;
                    lightsaberBehaviour.Crossguard = crossguarded; //aaaaaa
                    lightsaberBehaviour.SetColor(color);
                }
            };

            ModAPI.Register(lightsaber);
        }
    }

    public static class LinqReplacement
    {
        // sick ass replacement for LINQ
        public static void RemoveAll<TKey, TValue>(this Dictionary<TKey, TValue> dictionary, Func<TValue, bool> filter)
        {
            List<TKey> toRemove = new List<TKey>();
            foreach (var pair in dictionary)
                if (filter(pair.Value))
                    toRemove.Add(pair.Key);

            foreach (var key in toRemove)
                dictionary.Remove(key);
        }
    }

    [System.Serializable]
    public struct AudioPreset
    {
        public const string PathPrefix = "sfx/";

        public readonly string On;
        public readonly string Off;
        public readonly string Idle;
        public readonly string Swing;

        public AudioPreset(string on, string off, string idle = "idle.wav", string swing = "swing.wav")
        {
            On = PathPrefix + on;
            Off = PathPrefix + off;
            Idle = PathPrefix + idle;
            Swing = PathPrefix + swing;
        }

        public static AudioPreset Jedi { get { return new AudioPreset("light_on.mp3", "light_off.mp3"); } }
        public static AudioPreset Sith { get { return new AudioPreset("dark_on.mp3", "dark_off.mp3"); } }
        public static AudioPreset Luke { get { return new AudioPreset("luke_ignite.mp3", "light_off.mp3"); } }
        public static AudioPreset Guard { get { return new AudioPreset("light2on.mp3", "light2off.mp3", "guardidle.wav", "guardswing.wav"); } }
        public static AudioPreset Ezra { get { return new AudioPreset("ezraon.mp3", "ezraoff.mp3", "ezraidle.wav"); } }
        public static AudioPreset Sith2 { get { return new AudioPreset("dark2_on.mp3", "dark2_off.mp3"); } }
        public static AudioPreset Ahsoka { get { return new AudioPreset("ahsoka_on.mp3", "ahsoka_off.mp3", "ahsokaidle.wav"); } }
        public static AudioPreset Fart { get { return new AudioPreset("farton.mp3", "fartoff.mp3", "fartidle.wav", "fartswing.wav"); } }
        public static AudioPreset Jedi2 { get { return new AudioPreset("talon_on.mp3", "talon_off.mp3", "ezraidle.wav"); } }
        public static AudioPreset Crossguard { get { return new AudioPreset("cross_on.mp3", "cross_off.mp3", "crossidle.wav", "cross_swing.wav"); } }
    }
}

