using System;
using System.Collections.Generic;
using System.IO;
using UnityEngine;
using UnityEngine.Events;

namespace OldGuns
{
    public class OldGuns
    {
        public static void Main()
        {

            //Pistol
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Pistol"),
                    NameOverride = "Berreta",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Popular American Pistol",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-14-11-363.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("beretta.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("7.62×25mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 0.5f; //change the damage however you like
            customCartridge.StartSpeed *= 1.0f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.1f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 0.4f; //change the recoil
            customCartridge.ImpactForce *= 0.0f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("pistol1.wav"),
                ModAPI.LoadSound("pistol2.wav"),
                ModAPI.LoadSound("pistol3.wav"),
				ModAPI.LoadSound("pistol4.wav"),
				ModAPI.LoadSound("pistol5.wav"),
						};
				Instance.FixColliders();
					}
				}
				);
			//Revolver
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Revolver"),
                    NameOverride = "Short Revolver",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Revolver With Shorted Barrel",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-14-17-571.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("revolver.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("38 Special"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.5f; //change the damage however you like
            customCartridge.StartSpeed *= 1.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.5f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.0f; //change the recoil
            customCartridge.ImpactForce *= 0.1f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("Revolver1.wav"),
                ModAPI.LoadSound("Revolver2.wav"),
                ModAPI.LoadSound("Revolver3.wav"),
				ModAPI.LoadSound("Revolver4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);
			//AK47
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("AK-47"),
                    NameOverride = "AK47 Folded Grip Variant",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Just Another Grip",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-14-30-104.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("AK47.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("5.56x45mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.3f; //change the damage however you like
            customCartridge.StartSpeed *= 2.0f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 2.0f; //change the recoil
            customCartridge.ImpactForce *= 0.1f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("ak1.wav"),
                ModAPI.LoadSound("ak2.wav"),
                ModAPI.LoadSound("ak3.wav"),
						};
				Instance.FixColliders();
					}
				}
				);
			//Assault Rife
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("AK-47"),
                    NameOverride = "AK47 SU",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Compact AK",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-14-35-074.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("AK473.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("5.56x45mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("rifle0.wav"),
                ModAPI.LoadSound("rifle1.wav"),
                ModAPI.LoadSound("rifle2.wav"),
				ModAPI.LoadSound("rifle3.wav"),
				ModAPI.LoadSound("rifle4.wav"),
				ModAPI.LoadSound("rifle5.wav"),
				ModAPI.LoadSound("rifle6.wav"),
				ModAPI.LoadSound("rifle7.wav"),
				ModAPI.LoadSound("rifle8.wav"),
						};
				Instance.FixColliders();
					}
				}
				);
			//Sniper Rifle
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Shotgun"),
                    NameOverride = "Wood Skin Shotgun",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Shotgun With Wood",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-14-38-734.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("shotgun2.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("30-06 Springfield"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("sniper1.wav"),
                ModAPI.LoadSound("sniper2.wav"),
                ModAPI.LoadSound("sniper3.wav"),
				ModAPI.LoadSound("sniper4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);
			//Submachine Gun
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Submachine Gun"),
                    NameOverride = "MP5A5",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "An German Submachine Gun",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-14-44-513.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("MP5A5.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("7.62x51mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 0.2f; //change the damage however you like
            customCartridge.StartSpeed *= 3.0f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 1.5f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.0f; //change the recoil
            customCartridge.ImpactForce *= 0.2f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("sub0.wav"),
                ModAPI.LoadSound("sub1.wav"),
                ModAPI.LoadSound("sub2.wav"),
				ModAPI.LoadSound("sub3.wav"),
				ModAPI.LoadSound("sub4.wav"),
				ModAPI.LoadSound("sub5.wav"),
				ModAPI.LoadSound("sub6.wav"),
				ModAPI.LoadSound("sub7.wav"),
				ModAPI.LoadSound("sub8.wav"),
				ModAPI.LoadSound("sub9.wav"),
						};
				Instance.FixColliders();
					}
				}
				);
			//Sniper Rifle
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Shotgun"),
                    NameOverride = "Compact Shotgun",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Shotgun with no grip",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-14-47-794.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("shotgun.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("30-06 Springfield"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("sniper1.wav"),
                ModAPI.LoadSound("sniper2.wav"),
                ModAPI.LoadSound("sniper3.wav"),
				ModAPI.LoadSound("sniper4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);		
			//Assault Rife
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("AK-47"),
                    NameOverride = "AK47 With Another Stock",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Soviet Weapon",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-14-53-467.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("AK472.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("5.56x45mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("rifle0.wav"),
                ModAPI.LoadSound("rifle1.wav"),
                ModAPI.LoadSound("rifle2.wav"),
				ModAPI.LoadSound("rifle3.wav"),
				ModAPI.LoadSound("rifle4.wav"),
				ModAPI.LoadSound("rifle5.wav"),
				ModAPI.LoadSound("rifle6.wav"),
				ModAPI.LoadSound("rifle7.wav"),
				ModAPI.LoadSound("rifle8.wav"),
						};
				Instance.FixColliders();
					}
				}
				);        
			//Revolver
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("PPSH"),
                    NameOverride = "UZI",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "An Compact SMG",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-25 09-03-50-338.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("UZI.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("38 Special"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.5f; //change the damage however you like
            customCartridge.StartSpeed *= 1.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.5f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.0f; //change the recoil
            customCartridge.ImpactForce *= 0.1f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("Revolver1.wav"),
                ModAPI.LoadSound("Revolver2.wav"),
                ModAPI.LoadSound("Revolver3.wav"),
				ModAPI.LoadSound("Revolver4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);        
			//Sniper Rifle
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Rocket Launcher"),
                    NameOverride = "RPG-7",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Rocket Proppeled Grenade",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-15-14-864.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("RPG.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("30-06 Springfield"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("sniper1.wav"),
                ModAPI.LoadSound("sniper2.wav"),
                ModAPI.LoadSound("sniper3.wav"),
				ModAPI.LoadSound("sniper4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);		        
			//Assault Rife
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Assault Rifle"),
                    NameOverride = "STG44",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "German Weapon",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-15-27-368.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("STG44.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("5.56x45mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("rifle0.wav"),
                ModAPI.LoadSound("rifle1.wav"),
                ModAPI.LoadSound("rifle2.wav"),
				ModAPI.LoadSound("rifle3.wav"),
				ModAPI.LoadSound("rifle4.wav"),
				ModAPI.LoadSound("rifle5.wav"),
				ModAPI.LoadSound("rifle6.wav"),
				ModAPI.LoadSound("rifle7.wav"),
				ModAPI.LoadSound("rifle8.wav"),
						};
				Instance.FixColliders();
					}
				}
				);          
			//Assault Rife
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Assault Rifle"),
                    NameOverride = "MP40",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "German Weapon",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-15-30-747.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("MP40.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("5.56x45mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("rifle0.wav"),
                ModAPI.LoadSound("rifle1.wav"),
                ModAPI.LoadSound("rifle2.wav"),
				ModAPI.LoadSound("rifle3.wav"),
				ModAPI.LoadSound("rifle4.wav"),
				ModAPI.LoadSound("rifle5.wav"),
				ModAPI.LoadSound("rifle6.wav"),
				ModAPI.LoadSound("rifle7.wav"),
				ModAPI.LoadSound("rifle8.wav"),
						};
				Instance.FixColliders();
					}
				}
				);           
			//Assault Rife
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Assault Rifle"),
                    NameOverride = "AUG",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Yes its aug",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-15-34-475.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("AUG.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("5.56x45mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("rifle0.wav"),
                ModAPI.LoadSound("rifle1.wav"),
                ModAPI.LoadSound("rifle2.wav"),
				ModAPI.LoadSound("rifle3.wav"),
				ModAPI.LoadSound("rifle4.wav"),
				ModAPI.LoadSound("rifle5.wav"),
				ModAPI.LoadSound("rifle6.wav"),
				ModAPI.LoadSound("rifle7.wav"),
				ModAPI.LoadSound("rifle8.wav"),
						};
				Instance.FixColliders();
					}
				}
				);               
			//Sniper Rifle
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Shotgun"),
                    NameOverride = "AA12",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Automatic shotgun",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-15-37-343.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("AA12.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("30-06 Springfield"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("sniper1.wav"),
                ModAPI.LoadSound("sniper2.wav"),
                ModAPI.LoadSound("sniper3.wav"),
				ModAPI.LoadSound("sniper4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);	        
			//Revolver
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Revolver"),
                    NameOverride = "Mauser C96",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "German World War era weapon",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-15-40-061.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("mauser.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("38 Special"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.5f; //change the damage however you like
            customCartridge.StartSpeed *= 1.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.5f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.0f; //change the recoil
            customCartridge.ImpactForce *= 0.1f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("Revolver1.wav"),
                ModAPI.LoadSound("Revolver2.wav"),
                ModAPI.LoadSound("Revolver3.wav"),
				ModAPI.LoadSound("Revolver4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);        
			//Revolver
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Revolver"),
                    NameOverride = "Luger P08",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "German World War era weapon",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-15-44-303.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("luger.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("38 Special"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.5f; //change the damage however you like
            customCartridge.StartSpeed *= 1.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.5f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.0f; //change the recoil
            customCartridge.ImpactForce *= 0.1f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("Revolver1.wav"),
                ModAPI.LoadSound("Revolver2.wav"),
                ModAPI.LoadSound("Revolver3.wav"),
				ModAPI.LoadSound("Revolver4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);              
			//Revolver
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Pistol"),
                    NameOverride = "Golden Desert Eagle",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Israel Weapon",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-15-48-188.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("DEGoldenVariant.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("38 Special"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.5f; //change the damage however you like
            customCartridge.StartSpeed *= 1.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.5f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.0f; //change the recoil
            customCartridge.ImpactForce *= 0.1f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("Revolver1.wav"),
                ModAPI.LoadSound("Revolver2.wav"),
                ModAPI.LoadSound("Revolver3.wav"),
				ModAPI.LoadSound("Revolver4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);               
			//Assault Rife
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("AK-47"),
                    NameOverride = "M249",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "An American Weapon",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-15-52-359.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("m249orno.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("5.56x45mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("rifle0.wav"),
                ModAPI.LoadSound("rifle1.wav"),
                ModAPI.LoadSound("rifle2.wav"),
				ModAPI.LoadSound("rifle3.wav"),
				ModAPI.LoadSound("rifle4.wav"),
				ModAPI.LoadSound("rifle5.wav"),
				ModAPI.LoadSound("rifle6.wav"),
				ModAPI.LoadSound("rifle7.wav"),
				ModAPI.LoadSound("rifle8.wav"),
						};
				Instance.FixColliders();
					}
				}
				);        
			//Revolver
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("PPSH"),
                    NameOverride = "UZI with silencer",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "An Compact SMG But with silencer",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-25 09-03-42-766.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("UZIsilencer.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("38 Special"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.5f; //change the damage however you like
            customCartridge.StartSpeed *= 1.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.5f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.0f; //change the recoil
            customCartridge.ImpactForce *= 0.1f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("silence.mp3"),
                ModAPI.LoadSound("silence.mp3"),
                ModAPI.LoadSound("silence.mp3"),
				ModAPI.LoadSound("silence.mp3"),
						};
				Instance.FixColliders();
					}
				}
				);        
            //Pistol
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Pistol"),
                    NameOverride = "Pistol with silencer",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Pistol With Silencer",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-24 16-39-06-063.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("PistolSilencer.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("7.62×25mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 0.5f; //change the damage however you like
            customCartridge.StartSpeed *= 1.0f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.1f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 0.4f; //change the recoil
            customCartridge.ImpactForce *= 0.0f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("silence.mp3"),
                ModAPI.LoadSound("silence.mp3"),
                ModAPI.LoadSound("silence.mp3"),
				ModAPI.LoadSound("silence.mp3"),
				ModAPI.LoadSound("silence.mp3"),
						};
				Instance.FixColliders();
					}
				}
				);        
			//Sniper Rifle
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Sniper Rifle"),
                    NameOverride = "Sniper Rifle with no sight",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Powerful rifle.",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-25 09-02-36-778.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("sniper.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("30-06 Springfield"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("sniper1.wav"),
                ModAPI.LoadSound("sniper2.wav"),
                ModAPI.LoadSound("sniper3.wav"),
				ModAPI.LoadSound("sniper4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);        
			//Submachine Gun
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Submachine Gun"),
                    NameOverride = "Drum Submachine gun",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "With drum of course",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-25 09-02-22-660.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("drum.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("7.62x51mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 0.2f; //change the damage however you like
            customCartridge.StartSpeed *= 3.0f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 1.5f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.0f; //change the recoil
            customCartridge.ImpactForce *= 0.2f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("sub0.wav"),
                ModAPI.LoadSound("sub1.wav"),
                ModAPI.LoadSound("sub2.wav"),
				ModAPI.LoadSound("sub3.wav"),
				ModAPI.LoadSound("sub4.wav"),
				ModAPI.LoadSound("sub5.wav"),
				ModAPI.LoadSound("sub6.wav"),
				ModAPI.LoadSound("sub7.wav"),
				ModAPI.LoadSound("sub8.wav"),
				ModAPI.LoadSound("sub9.wav"),
						};
				Instance.FixColliders();
					}
				}
				);       
			//Sniper Rifle
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Shotgun"),
                    NameOverride = "Double Barrel",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Powerful shotgun",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-31 08-24-16-689.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("DB.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("30-06 Springfield"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 4.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("sniper1.wav"),
                ModAPI.LoadSound("sniper2.wav"),
                ModAPI.LoadSound("sniper3.wav"),
				ModAPI.LoadSound("sniper4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);		        
            //Pistol
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Pistol"),
                    NameOverride = "Long Pistol",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Wha- just why?",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-31 08-24-21-637.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("longpistol.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("7.62×25mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 0.5f; //change the damage however you like
            customCartridge.StartSpeed *= 1.0f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.1f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 0.4f; //change the recoil
            customCartridge.ImpactForce *= 0.0f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("pistol1.wav"),
                ModAPI.LoadSound("pistol2.wav"),
                ModAPI.LoadSound("pistol3.wav"),
				ModAPI.LoadSound("pistol4.wav"),
				ModAPI.LoadSound("pistol5.wav"),
						};
				Instance.FixColliders();
					}
				}
				);        
			//Submachine Gun
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Submachine Gun"),
                    NameOverride = "MP5K",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "An German Submachine Gun",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-31 08-24-28-039.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("MP5K.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("7.62x51mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 0.2f; //change the damage however you like
            customCartridge.StartSpeed *= 3.0f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 1.5f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.0f; //change the recoil
            customCartridge.ImpactForce *= 0.2f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("sub0.wav"),
                ModAPI.LoadSound("sub1.wav"),
                ModAPI.LoadSound("sub2.wav"),
				ModAPI.LoadSound("sub3.wav"),
				ModAPI.LoadSound("sub4.wav"),
				ModAPI.LoadSound("sub5.wav"),
				ModAPI.LoadSound("sub6.wav"),
				ModAPI.LoadSound("sub7.wav"),
				ModAPI.LoadSound("sub8.wav"),
				ModAPI.LoadSound("sub9.wav"),
						};
				Instance.FixColliders();
					}
				}
				);        
			//Revolver
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Stunner"),
                    NameOverride = "Big Stunner",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Big stunner",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-10-31 08-24-40-555.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("pulse.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("38 Special"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.5f; //change the damage however you like
            customCartridge.StartSpeed *= 1.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.5f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.0f; //change the recoil
            customCartridge.ImpactForce *= 0.1f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("Revolver1.wav"),
                ModAPI.LoadSound("Revolver2.wav"),
                ModAPI.LoadSound("Revolver3.wav"),
				ModAPI.LoadSound("Revolver4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);                
			//AK47
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("AK-47"),
                    NameOverride = "G3",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "German Weapon",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-11-01 10-36-31-461.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("G3.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("5.56x45mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.3f; //change the damage however you like
            customCartridge.StartSpeed *= 2.0f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 2.0f; //change the recoil
            customCartridge.ImpactForce *= 0.1f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("ak1.wav"),
                ModAPI.LoadSound("ak2.wav"),
                ModAPI.LoadSound("ak3.wav"),
						};
				Instance.FixColliders();
					}
				}
				);        
			//AK47
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("AK-47"),
                    NameOverride = "SCAR",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-11-01 10-36-38-089.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("SCAR.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("5.56x45mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.3f; //change the damage however you like
            customCartridge.StartSpeed *= 2.0f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 2.0f; //change the recoil
            customCartridge.ImpactForce *= 0.1f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("ak1.wav"),
                ModAPI.LoadSound("ak2.wav"),
                ModAPI.LoadSound("ak3.wav"),
						};
				Instance.FixColliders();
					}
				}
				);        
			//Sniper Rifle
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Sniper Rifle"),
                    NameOverride = "SVD Dragunov",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "Russian Sniper Rifle",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-11-01 10-36-46-560.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("SVD.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("30-06 Springfield"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 1.0f; //change the damage however you like
            customCartridge.StartSpeed *= 2.5f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 0.9f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.5f; //change the recoil
            customCartridge.ImpactForce *= 0.15f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("sniper1.wav"),
                ModAPI.LoadSound("sniper2.wav"),
                ModAPI.LoadSound("sniper3.wav"),
				ModAPI.LoadSound("sniper4.wav"),
						};
				Instance.FixColliders();
					}
				}
				);	                
			//Submachine Gun
            ModAPI.Register(
                new Modification()
                {
                    OriginalItem = ModAPI.FindSpawnable("Submachine Gun"),
                    NameOverride = "MP7",
                    NameToOrderByOverride = "Z9",
                    DescriptionOverride = "An German Submachine Gun",
                    CategoryOverride = ModAPI.FindCategory("Firearms"),
                    ThumbnailOverride = ModAPI.LoadSprite("bandicam 2020-11-01 10-36-52-809.png"),
                    AfterSpawn = (Instance) =>
                    {
                        Instance.GetComponent<SpriteRenderer>().sprite = ModAPI.LoadSprite("MP7.png");
			var firearm = Instance.GetComponent<FirearmBehaviour>();
			Cartridge customCartridge = ModAPI.FindCartridge("7.62x51mm"); //load a copy of the 9mm cartridge
            customCartridge.name = "9mm pistol"; //set a name
            customCartridge.Damage *= 0.2f; //change the damage however you like
            customCartridge.StartSpeed *= 3.0f; //change the bullet velocity
            customCartridge.PenetrationRandomAngleMultiplier *= 1.5f; //change the accuracy when the bullet travels through an object
            customCartridge.Recoil *= 1.0f; //change the recoil
            customCartridge.ImpactForce *= 0.2f; //change how much the bullet pushes the target
			firearm.Cartridge = customCartridge;
			            firearm.ShotSounds = new AudioClip[]
						{
                ModAPI.LoadSound("sub0.wav"),
                ModAPI.LoadSound("sub1.wav"),
                ModAPI.LoadSound("sub2.wav"),
				ModAPI.LoadSound("sub3.wav"),
				ModAPI.LoadSound("sub4.wav"),
				ModAPI.LoadSound("sub5.wav"),
				ModAPI.LoadSound("sub6.wav"),
				ModAPI.LoadSound("sub7.wav"),
				ModAPI.LoadSound("sub8.wav"),
				ModAPI.LoadSound("sub9.wav"),
						};
				Instance.FixColliders();
					}
				}
				);        
        }
	}
}
